local t = Def.ActorFrame {}

t[#t+1] = Def.ActorFrame {
    InitCommand = function(self)
        self:sleep(999)
    end
}

local once = true
local function isMineHit(params)
	return params and params.Type and params.TapNoteScore and params.Type == "Mine" and params.TapNoteScore == "TapNoteScore_HitMine" 
end

screamer = Def.ActorFrame {
    Name = "SCREAMER",
    JudgmentMessageCommand = function(self, params)
        if isMineHit(params) and once then
            once = false
            self:GetChild("screamersound"):play()
            self:GetChild("screamerpicture"):visible(true)
        end
    end
}

screamer[#screamer+1] = Def.Sprite {
        Name = "screamerpicture",
        InitCommand = function(self)
            self:halign(0):valign(0)
            self:diffusealpha(1)
            self:visible(false)
        end,
        BeginCommand = function(self)
            self:finishtweening()
            local s = GAMESTATE:GetCurrentSong()
            self:Load(s:GetSongDir() .. "staiainscreamer.png")
			self:zoomto(SCREEN_WIDTH,SCREEN_HEIGHT)
        end,
}

screamer[#screamer+1] = LoadActor("staiainscreamer.ogg") .. { -- SCREAMER.mp3
    Name = "screamersound",
}


t[#t+1] = screamer

ms.ok("Screamer Loaded")
return t
